%--------------------------------------------------------------------------
%
% check installation
%
%--------------------------------------------------------------------------
cfg = config();
if(isempty(cfg))
    error('config failed...');
end

%--------------------------------------------------------------------------
%
% dataset settings
%
%--------------------------------------------------------------------------
jobs   = {'2016_09_22_DE_50VP_F5_40x40_x5', ...
          '2016_09_22_IT_50VP_F5_42x42_x5', ...
          '2016_09_22_GR_50VP_F5_42x42_x5', ...
          '2018_03_01_ES_50VP_F5_40x40_x5', ...
          '2015_11_13_AR_50VP_F5_40x40_x5', ...
          '2014_10_09_EN_50VP_F5_35x35_x5' };
    
dics   = {'DE_50VP_F5', ...
          'IT_50VP_F5', ...  
          'GR_50VP_F5_v2', ...
          'ES_50VP_F5', ...
          'AR_VP_F5', ...
          'EN_VP50_F5'};

% datasets to be trained: set to 0 the elements you do not want to train
% (maybe becaus you've already trained them!)
% (the order is the same of "jobs" above)
jobRun = [ 1, ... % DE
           1, ... % IT
           1, ... % GR
           1, ... % ES
           1, ... % AR
           1];    % EN

jobNodes   = [40, 42, 42, 40, 40, 35];
jobSymbols = [33, 33, 29, 36, 34, 33];

jobLabels = {'DE', ...
             'IT', ...
             'GR', ...
             'ES', ...
             'AR', ...
             'EN'};

jobLangs = {'German', ...
            'Italian', ...
            'Greek', ...
            'Spanish', ...
            'Arabic', ...
            'English'};

jobsCount = length(jobs);

%--------------------------------------------------------------------------
%
% tsom settings
%
%--------------------------------------------------------------------------
tsomServicePort = 9000; % socket port for tsom server
tsomThreads = 0; % (0) number of logical cores to use for training; 0 = default = (maxcores - 1)
tsomEpochs = 100; % (100) number of training epochs
repsCount = 5; % (5) number of repetitions for training the same language and the same dataset

%--------------------------------------------------------------------------
%
% run training
%
%--------------------------------------------------------------------------
a = ari('Run', tsomServicePort);
for jobIndex = 1:jobsCount
    if(jobRun(jobIndex))
        a = ari('localhost', tsomServicePort); 
        ari(a, 'Version');
        ari(a, 'Wait');

        ari(a, sprintf('SetJobPath %s', job(jobs{jobIndex})));
        for repIndex = 1:repsCount
            ari(a, sprintf('SetJobIndex %d', repIndex - 1));
            ari(a, 'DeleteJobIndex');
            ari(a, sprintf('SetConfig %d,%d,%d', jobNodes(jobIndex), jobNodes(jobIndex), jobSymbols(jobIndex)));
            ari(a, sprintf('SetParam nThreads, %d', tsomThreads));

            ari(a, sprintf('SetDic %s', dics{jobIndex}));
            ari(a, 'DumpDic');
            ari(a, 'DumpTSOM');
            ari(a, sprintf('StartTraining %d, true', tsomEpochs)); % true = random order
            ari(a, 'Wait');
        end

        ari(a, 'Disconnect');
    end
end
a = ari(a, 'Quit');



