function cfg = config()

cfg = {};

% check
tsom_path = getenv('TSOM_PATH');
if(isempty(tsom_path))
    fprintf(2, 'config: ERROR: enviroment variable TSOM_PATH is not set.\n');
    fprintf(2, '               Either check TSOM installation or set it manually (e.g. TSOM_PATH = D:\\TSOM)\n');
    return;
end

% path
path(path, [tsom_path '\MATLAB_ROOT\LibUTILS_v2']);
path(path, [tsom_path '\MATLAB_ROOT\LibTSOM_v4']);

% cfg
cfg.app_path_data = [tsom_path '\TSOM_v4'];
cfg.utils_path_lib = [tsom_path '\MATLAB_ROOT\LibUTILS_v2'];